(function() {
  //    FILE:EventListView
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 5/15/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'models/event/EventModel', 'models/contact/ContactModel', 'models/time/TimeModel', 'models/timereport/TimereportModel', 'collections/timereport/TimereportCollection', "views/project/ProjectDetailView", 'models/project/ProjectModel', 'views/request/EditRequestView', 'views/contact/ContactView', "views/contact/CompanyView", "views/cfield/CustomFieldView", 'views/task/EditTaskView', 'views/booking/EditBookingView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, EventModel, ContactModel, TimeModel, TimereportModel, TimereportCollection, ProjectDetailView, ProjectModel, EditRequestView, ContactView, CompanyView, CustomFieldView, EditTaskView, EditBookingView) {
    var EventView;
    return EventView = class EventView extends Backbone.View {
      initialize(usr, bs, eventsCol, event1, dayToShow, obj1) {
        this.usr = usr;
        this.bs = bs;
        this.eventsCol = eventsCol;
        this.event = event1;
        this.dayToShow = dayToShow;
        this.obj = obj1;
        //#console.log 'EVent View Init '+@event.get('mainHeader')
        this.event.on('change', this.update_event, this);
        this.event.on('delete', this.event_deleted, this);
        return this.time = new TimeModel();
      }

      attributes() {
        return {
          'data-role': 'page'
        };
      }

      events() {
        return {
          'tap #id-btn-back': 'btnBackClicked',
          'tap .contact-link': 'contactClicked',
          'tap .involved-link': 'involvedClicked',
          'tap #id-btn-edit': 'btnEditClicked',
          'tap .btn-submenu-event': 'subMenuEventClicked',
          'tap #id-btn-projectName': 'btnProjectClicked',
          'tap .go-to-timereport': 'btnTimeReportClicked',
          'pageshow': 'update_event',
          'tap .edit-request-note': 'btnShowEditNoteClicked',
          'tap #id-btn-done-note': 'btnDoneNoteClicked',
          //DELETING
          //'tap #id-btn-delete-request': 'btnDeleteRequestClicked'
          //POPUP CLOSE
          'tap .popUpCancel': 'btnPopupClose',
          //POPUP CONFIRM
          'tap .popUpConfirm': 'btnPopupConfirm'
        };
      }

      render() {
        var template;
        template = Handlebars.templates['EventView'];
        switch (this.event.get('type')) {
          case 'request':
            this.title = 'Request';
            break;
          case 'task':
            this.title = 'Task';
            break;
          case 'personnel':
            this.title = 'Personnel Booking';
            break;
          default:
            if (this.event.get('isAdhoc')) {
              this.title = 'Adhoc Time Report';
            } else {
              this.title = 'Booking';
            }
        }
        this.$el.html(template({
          canEdit: this.event.__user_can_edit_event(this.usr),
          title: this.title
        }));
        this.$el.attr('id', 'id-EventView');
        return this.addSidePanel();
      }

      addSidePanel() {
        var MenuView;
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr, this.obj);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      subMenuEventClicked(event) {
        var btn, id;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        id = btn.attr('data-target');
        this.$el.find('.subEventView').hide();
        return this.$el.find(id).show();
      }

      btnBackClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        //@eventsCol.set_day_events(@usr,@event.get('day'),@obj)
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      btnEditClicked(event) {
        var popUp, popUpHtml, view;
        event.preventDefault();
        event.stopPropagation();
        switch ($(event.currentTarget).attr('data-type')) {
          case 'request':
            if (this.event.get('requestStatus') === 'accepted') {
              popUpHtml = `<div data-role="popup" id="popupAlert" data-overlay-theme="a" data-theme="c" data-dismissible="false" class="ui-corner-all">
<div data-role="header" data-theme="a" class="ui-corner-top">
<h3>This request has already been accepted</h3>
</div>
<div data-role="content" data-theme="d" class="ui-corner-bottom ui-content">
<p>This request has already been approved. Editing will mean resubmitting it for approval. Do you wish to continue?<p>
<a href="#" data-role="button" data-inline="true" data-rel="back" data-theme="c" class="popUpConfirm">Confirm</a>
<a href="#" data-role="button" data-inline="true" data-rel="back" data-theme="c" class="popUpCancel">Cancel</a>
</div>
</div>`;
              this.$el.append(popUpHtml);
              popUp = this.$el.find('#popupAlert');
              popUp.popup();
              popUp.trigger('create');
              popUp.popup('open');
            } else {
              if (!EditRequestView) {
                EditRequestView = require('views/task/EditRequestView');
              }
              view = new EditRequestView(this.usr, this.obj, this.bs, this.eventsCol, this.event, this.dayToShow, this.title);
            }
            break;
          case 'personnel':
            if (!EditRequestView) {
              EditRequestView = require('views/task/EditRequestView');
            }
            view = new EditRequestView(this.usr, this.obj, this.bs, this.eventsCol, this.event, this.dayToShow, this.title);
            break;
          case 'task':
            if (!EditTaskView) {
              EditTaskView = require('views/task/EditTaskView');
            }
            view = new EditTaskView(this.usr, this.obj, this.bs, this.eventsCol, this.event, this.dayToShow);
            break;
          case 'booking':
            if (!EditBookingView) {
              EditBookingView = require('views/booking/EditBookingView');
            }
            view = new EditBookingView(this.usr, this.obj, this.bs, this.eventsCol, this.event, this.dayToShow);
            break;
          case 'adhoc':
            if (!EditBookingView) {
              EditBookingView = require('views/booking/EditBookingView');
            }
            view = new EditBookingView(this.usr, this.obj, this.bs, this.eventsCol, this.event, this.dayToShow);
        }
        if (view) {
          return $.mobile.jqmNavigator.pushView(view, {
            transition: "none"
          });
        }
      }

      event_deleted() {
        this.eventsCol.set_day_events(this.usr, this.event.get('day'), this.obj);
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      btnPopupClose(event) {
        return this.$el.find('#popupAlert').remove();
      }

      btnPopupConfirm(event) {
        var view;
        this.$el.find('#popupAlert').remove();
        if (!EditRequestView) {
          EditRequestView = require('views/task/EditRequestView');
        }
        view = new EditRequestView(this.usr, this.obj, this.bs, this.eventsCol, this.event, this.dayToShow, this.title);
        if (view) {
          return $.mobile.jqmNavigator.pushView(view, {
            transition: "none"
          });
        }
      }

      btnProjectClicked(event) {
        var obj, project, projectID, view;
        event.preventDefault();
        event.stopPropagation();
        if (!ProjectDetailView) {
          ProjectDetailView = require("views/project/ProjectDetailView");
        }
        if (!ProjectModel) {
          ProjectModel = require('models/project/ProjectModel');
        }
        obj = $(event.currentTarget);
        projectID = obj.attr('data-projectID');
        project = new ProjectModel();
        project.get_project_detail(this.usr, projectID);
        view = new ProjectDetailView(this.usr, project);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      contactClicked(event) {
        var contact, contactID, obj, view;
        event.preventDefault();
        event.stopPropagation();
        if (!ContactView) {
          ContactView = require("views/contact/ContactView");
        }
        obj = $(event.currentTarget);
        contactID = obj.attr('data-contactID');
        contact = new ContactModel();
        if (contactID) {
          contact.get_details_contact(this.usr.get('sessionID'), contactID);
          view = new ContactView(this.usr, contact);
        } else {
          contactID = obj.attr('data-contactCompanyID');
          contact.get_details_company(this.usr.get('sessionID'), contactID);
          if (!CompanyView) {
            CompanyView = require("views/contact/CompanyView");
          }
          view = new CompanyView(this.usr, contact);
        }
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      involvedClicked(event) {
        var contact, contactID, obj, type, view;
        event.preventDefault();
        event.stopPropagation();
        if (!ContactView) {
          ContactView = require("views/contact/ContactView");
        }
        obj = $(event.currentTarget);
        contactID = obj.attr('data-contactID');
        type = obj.attr('data-objectType');
        if (type === 'user1' || type === 'user2' || type === 'user3' || type === 'resource') {
          contact = new ContactModel();
          contact.get_details_contact(this.usr.get('sessionID'), contactID);
          view = new ContactView(this.usr, contact);
          return $.mobile.jqmNavigator.pushView(view, {
            transition: "none"
          });
        }
      }

      btnTimeReportClicked(event) {
        var TimereportDetailView, bookingID, day, timereport, timereportCol, view;
        event.preventDefault();
        event.stopPropagation();
        bookingID = this.event.get('eventID');
        day = this.event.get('day');
        timereportCol = new TimereportCollection();
        timereport = new TimereportModel({
          bookingID: bookingID,
          day: day
        });
        timereport.collection = timereportCol;
        timereport.get_details_timereport(this.usr.get('sessionID'));
        if (!TimereportDetailView) {
          TimereportDetailView = require('views/timereport/TimereportDetailView');
        }
        view = new TimereportDetailView(this.usr, timereport, timereportCol, "EventView", this.eventsCol, this.obj);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

      btnShowEditNoteClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.$el.find('.div-request-note-form').toggle();
      }

      btnDoneNoteClicked(event) {
        var eventID, note, requestObject, that;
        event.stopPropagation();
        event.preventDefault();
        that = this;
        note = window.html_newlines(this.$el.find("#id-input-booking-note").val());
        eventID = this.event.get('eventID') ? this.event.get('eventID') : this.event.get('bookingID');
        requestObject = {
          'sessionID': this.usr.get('sessionID'),
          'note': note,
          'bookingID': eventID
        };
        $.mobile.loading('show');
        return this.event.set_booking_note(requestObject).done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            that.$el.find('.div-request-note-form').hide();
            return that.$el.find('p.edit-request-note').text(note);
          }
        }).fail(function(data, textStatus, jqXHR) {
          return false;
        }).always(function(data, textStatus) {
          return $.mobile.loading('hide');
        });
      }

      update_event(mdl) {
        var id;
        if (mdl instanceof jQuery.Event && !this.event.get('Booking')) {
          return;
        }
        if (this.event.get('Booking')) {
          mdl = this.event;
        }
        //IN CASE WE DONT KNOW THE DAY BEFORE LOADING THE BOOKING WE UPDATE IT WHEN THE MODEL IS FILLED FROM API
        if (!this.dayToShow) {
          this.dayToShow = moment(mdl.get('Booking').day);
        }
        this.$el.find('#id-spinner-all').hide();
        this.__update_details_tab(mdl);
        if (mdl.get('Booking').Involved) {
          this.__update_involved_tab(mdl);
        }
        if (mdl.get('Booking').CustomField) {
          this.__update_cfield_tab(mdl);
        }
        if (this.event.get('type') === 'request') {
          this.__update_approvers_tab(mdl);
        }
        id = this.$el.find('.btn-submenu-event').attr('data-target');
        this.$el.find('.subEventView').hide();
        if (this.usr.get('openInvolvedTabAsDefault')) {
          this.$el.find("#divEventInvolved").show();
          this.$el.find("#id-submenu-event-details").removeClass("ui-btn-active");
          return this.$el.find("#id-submenu-timereport-breaks").addClass("ui-btn-active");
        } else {
          return this.$el.find(id).show();
        }
      }

      __update_details_tab(mdl) {
        /* FIRST SET HEADER  FOR ALL TYPES OF EVENTS*/
        var divWrapper, event, headerHTML, html, legend, type;
        headerHTML = this.__generate_header_details_html(mdl);
        this.$el.find('#id-div-event-header').html(headerHTML);
        //# NOW SET THE LEGEND (NUMBER OF OCCURENCIES)
        legend = this.__generate_legend_html(mdl);
        this.$el.find('#id-p-request-legend').text(legend);
        //#FIRST INFO LAYER ###
        event = mdl.get('Booking');
        type = event.parentType;
        divWrapper = this.$el.find('#id-div-event-wrapper-info');
        if (type === 'personnel') {
          html = this.__generate_personnel_details_html(event);
        } else if (type === 'request') {
          html = this.__generate_request_details_html(event);
        } else if (type === 'project' || type === 'task') {
          html = this.__generate_booking_details_html(event);
        }
        divWrapper.html(html);
        return divWrapper.trigger('create');
      }

      __update_approvers_tab(mdl) {
        var approvers, group, groups, i, len, ul, users;
        users = mdl.requestUser ? mdl.requestUser : mdl.get('Booking').requestUser;
        groups = mdl.requestGroup ? mdl.requestGroup : mdl.get('Booking').requestGroup;
        if (typeof users !== 'undefined') {
          if (!Array.isArray(users)) {
            users = [users];
          }
          approvers = [...users];
        } else {
          approvers = [];
        }
        if (typeof groups !== 'undefined') {
          if (!Array.isArray(groups)) {
            groups = [groups];
          }
          for (i = 0, len = groups.length; i < len; i++) {
            group = groups[i];
            approvers.push({
              userId: group.groupId,
              userName: group.groupName
            });
          }
        }
        ul = this.$el.find('#id-ul-approvers');
        ul.empty();
        _.each(approvers, function(approver) {
          var id, li, name;
          name = approver.userName;
          id = approver.userId;
          li = `<li class='involved-link' data-userID=\"${id}\" data-userName=\"${name}\"> <span class=\"header\">${name}</span>`;
          li += '</li>';
          return ul.append(li);
        });
        return ul.listview('refresh');
      }

      __update_involved_tab(mdl) {
        var dayStartsAt, inv, involved, li, that, timeHTML, type, ul, usesAMPM;
        that = this;
        dayStartsAt = parseInt(this.usr.get('dayStartsAt'), 10);
        usesAMPM = parseInt(this.usr.get('usesAMPM'), 10);
        involved = mdl.Involved ? mdl.Involved : mdl.get('Booking').Involved;
        ul = this.$el.find('#id-ul-involved');
        ul.empty();
        if (_.isArray(involved)) {
          _.each(involved, function(inv) {
            var li, subheader1, timeHTML, type;
            type = inv.objectType;
            if (inv.timeIn === 0 && inv.timeOut === 24) {
              timeHTML = "All Day";
            } else {
              timeHTML = `${that.time.get_time_string_from_float(dayStartsAt, usesAMPM, inv.timeIn)}<br/>${that.time.get_time_string_from_float(dayStartsAt, usesAMPM, inv.timeOut)}`;
            }
            li = `<li class='involved-link' data-contactID=\"${inv.objectID}\" data-objectType=\"${inv.objectType}\" data-objectClassID=\"${inv.objectClassID}\" data-bookingLineID=\"${inv.bookingLineID}\"> <span class=\"spanTimeEvent\" >${timeHTML}</span> <span class=\"spanSeparator\"/> <span class=\"header\">${inv.name}</span>`;
            subheader1 = '';
            if (inv.objectClassName) {
              subheader1 = inv.objectClassName;
            }
            if (inv.activityName) {
              subheader1 += " &bull; " + inv.activityName;
            }
            if (subheader1 !== '') {
              li += `<span class='subheader1'>${subheader1}</span>`;
            }
            if (inv.note) {
              li += `<span class='subheader2'>${inv.note}</span>`;
            }
            if (type === 'user1' || type === 'user2' || type === 'user3' || type === 'resource') {
              li += '<span class="fwi-arrow-right arrow-right"/>';
            }
            li += '</li>';
            return ul.append(li);
          });
        } else {
          inv = involved;
          type = inv.objectType;
          if (inv.timeIn === 0 && inv.timeOut === 24) {
            timeHTML = "All Day";
          } else {
            timeHTML = `${that.time.get_time_string_from_float(dayStartsAt, usesAMPM, inv.timeIn)}<br/>${that.time.get_time_string_from_float(dayStartsAt, usesAMPM, inv.timeOut)}`;
          }
          li = `<li class='involved-link' data-contactID=\"${inv.objectID}\" data-objectType=\"${inv.objectType}\" data-objectClassID=\"${inv.objectClassID}\" data-bookingLineID=\"${inv.bookingLineID}\">`;
          li += `<span class=\"spanTimeEvent\" >${timeHTML}</span>`;
          li += '<span class="spanSeparator"/>';
          li += `<span class='header'>${inv.name}</span>`;
          if (inv.objectClassName) {
            li += `<span class='subheader1'>${inv.objectClassName}</span>`;
          }
          if (inv.note) {
            li += `<span class='subheader2'>${inv.note}</span>`;
          }
          if (type === 'user1' || type === 'user2' || type === 'user3' || type === 'resource') {
            li += '<span class="fwi-arrow-right arrow-right"/>';
          }
          li += '</li>';
          ul.append(li);
        }
        return ul.listview('refresh');
      }

      __update_cfield_tab(mdl) {
        var cfields, ul;
        ul = this.$el.find('#id-ul-event-cfield');
        ul.empty();
        cfields = mdl.CustomField ? mdl.CustomField : mdl.get('Booking').CustomField;
        if (!_.isArray(cfields)) {
          cfields = [cfields];
        }
        if (!CustomFieldView) {
          CustomFieldView = require("views/cfield/CustomFieldView");
        }
        _.each(cfields, (cf) => {
          var cfLi;
          cfLi = new CustomFieldView(this.usr, cf, 'read').render().el;
          //li = @$el.find('<li>').append(form)
          return ul.append(cfLi);
        });
        /* UPDATING DOM STYLE */
        ul.listview();
        ul.listview('refresh');
        return this.$el.find('#divEventCField').trigger('create');
      }

      __generate_header_details_html(mdl) {
        var headerHTML;
        headerHTML = '<div class="ui-block-a time" >';
        if (mdl.__is_all_day()) {
          headerHTML += "<p id='id-p-allDay'>All Day</p>";
        } else {
          headerHTML += `<p id='id-p-times'> <span id='id-span-timeIn'>${Handlebars.helpers.timeFloatToString(this.usr.get('dayStartsAt'), this.usr.get('usesAMPM'), mdl.get('Booking').timeIn)}</span> <br/> <span id='id-span-timeOut'>${Handlebars.helpers.timeFloatToString(this.usr.get('dayStartsAt'), this.usr.get('usesAMPM'), mdl.get('Booking').timeOut)}</span> </p>`;
        }
        headerHTML += "</div>";
        headerHTML += '<div class="ui-block-b info">';
        headerHTML += `<p class='main-date'><strong>${this.dayToShow.format('dddd Do MMMM')}</strong></p> <p class='year'><small>${mdl.get_year()}</small></p> <p class='human-date'><small>${mdl.get_human_date(this.dayToShow)}</small></p>`;
        return headerHTML += "</div>";
      }

      __generate_personnel_details_html(event) {
        var html, note, type;
        type = event.personnelTypeName;
        note = window.html_newlines(event.note);
        html = `<div class=\"div-event-info\"><div class=\"ui-grid-a\" > <div class=\"ui-block-a div-event-label\" > <p>type</p> </div> <div class=\"ui-block-b div-event-value\"> <p>${type}</p> </div> </div>`;
        if (note) {
          html += `<div class=\"ui-grid-a div-event-note\" > <p id='id-p-note'>${note}</p> </div>`;
        }
        return html += "</div>";
      }

      __generate_request_details_html(event) {
        var html, note, statusHTML;
        note = window.html_newlines(event.note);
        html = `<div class='div-event-info'> <div class='ui-grid-a ' > <div class='ui-block-a div-event-label' > <p>Name</p> </div> <div class='ui-block-b div-event-value'> <p id='id-p-name-event'>${event.name}</p> </div> </div>`;
        if (this.usr.get('usePendingRequestReminderHours')) {
          html += `<div class='ui-grid-a ' > <div class='ui-block-a div-event-label' > <p>Maximum Approval Time</p> </div> <div class='ui-block-b div-event-value'> <p id='id-p-max-approval-event'>${event.requestMaxApprovalTime}</p> </div> </div>`;
        }
        if (event.requestUserName) {
          html += `<div class='div-event-info'> <div class='ui-grid-a ' > <div class='ui-block-a div-event-label' > <p>Send To</p> </div> <div class='ui-block-b div-event-value'> <p id='id-p-name-event'>${event.requestUserName}</p> </div> </div>`;
        }
        if (note !== "undefined") {
          html += `<div class=\"ui-grid-a div-event-note\" > <p id='id-p-note'>${note}</p> </div>`;
        }
        html += "</div>";
        statusHTML = this.__get_status_html(event.requestStatus);
        html += `<div class='div-event-info'> <div class='ui-grid-a ' > <div class='ui-block-a div-event-label' > <p>Status</p> </div> <div class='ui-block-b div-event-value'> <p id='id-p-status-event'>${statusHTML}</p> </div> </div>`;
        if (event.handledBy) {
          html += `<div class='ui-grid-a div-event-status' > <div class='ui-block-a div-event-label' > <p>Handled By</p> </div> <div class='ui-block-b div-event-value'> <button data-icon='arrow-r' data-iconpos='right' data-mini='true' id='id-p-responseByName' class='contact-link' data-contactID=\"${event.responseByID}\">${event.responseByName}</button> </div> </div>`;
        }
        return html;
      }

      __generate_booking_details_html(event) {
        var binder, checkpoint, client, contact, createdBy, createdDate, html, htmlDates, nameEvent, note, noteEditable, project, status, texts, type;
        type = event.parentType;
        status = event.status;
        note = window.html_newlines(event.note);
        project = event.parentName;
        createdBy = event.createdByName;
        createdDate = event.createdDate;
        contact = event.contactName;
        binder = event.projectBinderFullPathName;
        client = event.contactCompanyName;
        nameEvent = event.name;
        checkpoint = event.stageName;
        noteEditable = false;
        texts = new Object();
        texts.tr = "Timereport";
        if (window.isCompany("rt1.tv")) {
          texts.tr = "Produktionsbericht";
        }
        if (event.isReadonly && event.allowEditingNote) {
          noteEditable = true;
        }
        if (nameEvent) {
          html = `<div class='div-event-info'> <div class='ui-grid-a ' > <div class='ui-block-a div-event-label' > <p>Name</p> </div> <div class='ui-block-b div-event-value'> <p id='id-p-name-event'>${nameEvent}</p> </div> </div>`;
        } else {
          html = "<div class='div-event-info'>";
        }
        html += `<div class='ui-grid-a ' > <div class='ui-block-a div-event-label' > <p>Status</p> </div> <div class='ui-block-b div-event-value'> <p id='id-p-status-event'>${status}</p> </div> </div>`;
        html += `<div class='ui-grid-a ' > <div class='ui-block-a div-event-label'> <p>Checkpoint</p> </div> <div class='ui-block-b div-event-value' id='id-div-booking-stage'> <p id='id-p-checkpoint'>${this.__get_checkpoint_html(checkpoint)}</p> </div> </div>`;
        //# DANISH HACK FOR ALLOWING EDITING NOTE IN A READ ONLY BOOKING
        if (!noteEditable) {
          if (note) {
            html += `<div class=\"ui-grid-a div-event-note\" > <p id='id-p-note'>${note}</p> </div>`;
          }
        } else {
          html += `<div class=\"ui-grid-solo div-event-note\" > <span class='fwi-edit edit-request-note' style='float: right'></span> <p class='edit-request-note'>${note}</p> <div class=\"div-request-note-form ui-block-a form-request-component\" style='display:none;'> <textarea id='id-input-booking-note' >${note}</textarea> <span id='id-btn-done-note' class='btn' >Done Editing Note</> </div> </div>`;
        }
        //CREATED BY
        htmlDates = `<div class='ui-grid-a div-event-project' > <div class='ui-block-a div-event-label'> <p>Created By</p> </div> <div class='ui-block-b div-event-value' > <button data-icon='arrow-r' data-iconpos='right' data-mini='true' id='id-p-createdByName' class='contact-link' data-contactID=\"${event.createdByID}\">${createdBy}</button> </div> </div>`;
        //DATES CREATED ON
        htmlDates += `<div class='ui-grid-a ' > <div class='ui-block-a div-event-label'> <p>Created On</p> </div> <div class='ui-block-b div-event-value' > <p id='id-p-createdDate'>${Handlebars.helpers.beautyDate(createdDate)}</p> </div> </div>`;
        if (type === 'task') {
          html += htmlDates;
        }
        //TIMEREPORTED
        html += `<div class='ui-grid-a ' > <div class='ui-block-a div-event-label'> <p>${texts.tr}</p> </div> <div class='ui-block-b div-event-value go-to-timereport' id='id-div-booking-stage'> <span class='fwi-time-report' style='float: right'/> <p id='id-p-checkpoint'>${event.isTimereported === 1 ? 'YES' : 'NO'}</p> </div> </div>`;
        if (type === 'project') {
          html += `<div class='div-event-project' > <div class='ui-grid-a' > <div class='ui-block-a div-event-label' > <p>Project</p> </div> <div class='ui-block-b div-event-value'> <button data-icon='arrow-r' data-iconpos='right' data-mini='true' id='id-btn-projectName' class='project-link' data-projectID=\"${event.parentID}\">Project ${project}</button> </div> </div>`;
          if ((binder != null) && binder !== "undefined") {
            html += `<div class='ui-grid-a' > <div class='ui-block-a div-event-label' > <p>Binder</p> </div> <div class='ui-block-b div-event-value'> <p id='id-p-binder'>${binder}</p> </div> </div>`;
          }
          html += `<div class='ui-grid-a' > <div class='ui-block-a div-event-label' > <p>Client</p> </div> <div class='ui-block-b div-event-value'> <button data-icon='arrow-r' data-iconpos='right' data-mini='true' id='id-p-contactCompanyName' class='contact-link' data-contactCompanyID=\"${event.contactCompanyID}\">${client}</button> </div> </div> <div class='ui-grid-a' > <div class='ui-block-a div-event-label' > <p>Contact</p> </div> <div class='ui-block-b div-event-value'> <button data-icon='arrow-r' data-iconpos='right' data-mini='true' id='id-p-contactName' class='contact-link' data-contactID=\"${event.contactID}\">${contact}</button> </div> </div>`;
          html += htmlDates;
          html += "</div>";
        }
        return html;
      }

      __generate_legend_html(mdl) {
        var booking, curDate, curIndex, dateIn, dateOut, day;
        if (mdl instanceof EventModel) {
          booking = mdl.get('Booking');
        } else {
          booking = mdl.Booking;
        }
        day = this.dayToShow.format('YYYY-MM-DD');
        if (_.isArray(booking != null ? booking.occursOnDay : void 0)) {
          dateIn = Moment(booking.occursOnDay[0], 'YYYY-MM-DD');
          dateOut = Moment(booking.occursOnDay[booking.occursOnDay.length - 1], 'YYYY-MM-DD');
          curDate = day;
          curIndex = _.indexOf(booking.occursOnDay, curDate) + 1;
          return dateIn.format('dddd Do MMMM') + ' - ' + dateOut.format('dddd Do MMMM') + '(' + curIndex + '/' + booking.occursOnDay.length + ')';
        } else {
          this.$el.find('#id-p-request-legend').hide();
          return '';
        }
      }

      __get_checkpoint_html(checkpoint) {
        var html;
        html = '';
        switch (checkpoint) {
          case 'Cancelled':
            html = '<span class="fwi-checkpoint checkpoint-cancel"> </span>';
            break;
          case 'In Progress':
            html = '<span class="fwi-checkpoint checkpoint-progress" /> ';
            break;
          case 'Pending':
            html = '<span class="fwi-checkpoint checkpoint-pending" /> ';
            break;
          case 'Ignore':
            html = '<span class="fwi-checkpoint checkpoint-ignore" /> ';
            break;
          case 'Completed':
            html = '<span class="fwi-checkpoint-finish checkpoint-complete" /> ';
        }
        return html + `<span class=\"checkpoint-name\">${checkpoint}</span>`;
      }

      __get_status_html(status) {
        var html;
        html = '';
        switch (status) {
          case 'pending':
            html = '<span style="color:yellow;font-size: 20px;">&bull;</span>';
            break;
          case 'declined':
            html = '<span style="color:darkred;font-size: 20px;">&bull;</span>';
            break;
          case 'accepted':
            html = '<span style="color:darkgreen;font-size: 20px;">&bull;</span>';
            break;
          case 'cancelled':
            html = '<span style="color:darkgreen;font-size: 20px;">&bull;</span>';
        }
        return html + `<span class=\"checkpoint-name\">${status}</span>`;
      }

      __get_type_event() {
        var type;
        type = this.event.get('type');
        if (!type) {
          type = this.event.get('parentType');
        }
        /* WE FORCE TASK and PROJECT TYPE TO BOOKING */
        if (type === 'task' || type === 'project') {
          type = 'Booking';
        }
        return type;
      }

    };
  });

  //PROJECT = BOOKING
//REST EQUAL event.type

}).call(this);
